;
;								EJEMPLO 14
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;El TMR0 en el modo contador de eventos externos
;
;Sobre el display 7 segmentos conectado a la puerta B se visualizar el nmero de pulsos 
;aplicados por RA4/T0CKI al TMR0, Cuando lleguen 6 pulsos se provoca una interrupcin 
;cuyo tratamiento activa todos los segmentos del display durante 1 seg. y luego se apagan. 
;Para repetir el proceso se debe accionar el pulsador de RESET
	
		List	p=16F876A	;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

		__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC
                    
Contador		equ	0x20				;Variable del contador
		
				org	0x00				;Vector de RESET
				goto	Inicio
				org	0x04
				goto	Interrupcion	;Vector de interrupcin
				org	0x05
	
;*******************************************************************************************************************************
;Delay_1s: Rutina de temporizacin de propsito general de 1 segundo de duracin

Delay_1s		movlw	.100
				movwf	Contador	;Inicia contador de temporizaciones de 10 ms con 100 (1")
Seguir			bcf		INTCON,T0IF	;Reponer flag del TMR0
				movlw 	~.39
           		movwf 	TMR0      	;Repone el TMR0 con 39 para temporizar 10 mS
Delay_10ms		btfss	INTCON,T0IF	;Han transcurrido 10 mS ??
				goto	Delay_10ms	;No, esperar
				decfsz 	Contador,F	;Decrementa el contador. Se ha repetido 100 veces la temporizacin ?
				goto	Seguir		;No
				return

;**********************************************************************************
;Tabla: Esta rutina convierte el cdigo BCD presente en los 4 bits de menos peso
;del reg. W en su equivalente a 7 segmentos. El cdigo 7 segmentos retorna tambin
;en el reg. W

Tabla:			addwf	PCL,F			;Desplazamiento sobre la tabla
				retlw	b'00111111'		;Dgito 0
				retlw	b'00000110'		;Dgito 1
				retlw	b'01011011'		;Dgito 2
				retlw	b'01001111'		;Dgito 3
				retlw	b'01100110'		;Dgito 4
				retlw	b'01101101'		;Dgito 5
				retlw	b'01111101'		;Dgito 6
				retlw	b'00000111'		;Dgito 7
				retlw	b'01111111'		;Dgito 8
				retlw	b'01100111'		;Dgito 9

;Programa de tratamiento de la interrupcin provocada cuando TMR0 ha contado 6 eventos externos

Interrupcion	bsf		STATUS,RP0	;Selecciona banco 1
				movlw	b'00000111'
				movwf	OPTION_REG	;Preescaler de 256 para el TMR0 en el modo temporizador
				bcf		STATUS,RP0	;Selecciona banco 0
				bcf		INTCON,T0IF	;Repone el flag del TMR0
				bcf		INTCON,T0IE	;Dsactiva interrupcin del TMR0
				movlw	b'11111111'
				movwf	PORTB		;Activa todos los segmentos del display
				call	Delay_1s	;Temporiza 1 segundo
				clrf	PORTB		;Desactiva los segmentos del display
				sleep				;Sistema detenido

Inicio	        clrf 	PORTB		;Borra los latch de salida
				bsf		STATUS,RP0	;Selecciona banco 1
				clrf	TRISB		;Puerta B se configura como salida
				movlw	0x06
				movwf	ADCON1		;Puerta A digital
				movlw	b'00111111'		
				movwf	TRISA		;Puerta A se configura como entrada		
				movlw	b'00111000'	;TMR0 modo contador sensible al flanco descendente de RA4/T0CKI
				movwf	OPTION_REG	;Preescaler de 1 para el TMR0 en el modo contador
				bcf		STATUS,RP0	;Selecciona banco 0			                                                                         
		
				movlw	~.6
				movwf	TMR0		;Repone el TMR0 con n de pulsos externos a contar
				movlw	b'10100000'
				movwf	INTCON		;Activa interrupcin del TMR0

Loop			comf	TMR0,W		;lee el valor actual del TMR0
				andlw	b'00001111'
				call	Tabla		;Convierte a 7 segmentos
				movwf	PORTB		;Lo visualiza sobre el display
				goto	Loop

				end					;Fin del programa fuente

